% Script to find median of data across time window
% started 10/11/2018
% Updated and made compatible with Matlab R2021b, 24/08/22
% requires input file in workspace read from spread sheet with columns of
% Depth, Par_value (eg Sulphate), sample thickness, layer thickness, acc rate, Age (other
% columns optional); needs those headers as variable titles
% Count number of data points in file
numrows = numel(Depth);
numrows
% Check expt, used for filename for output, strings in response to first two prompts
% should be in ""
prompt = 'What site is this file? ';
result = input(prompt);
Site = result
prompt = 'What parameter (eg sulfate, DEP) is this file? ';
result = input(prompt);
Param = result
% Decide age range over which to calculate medians
prompt = 'Over what age range (years) do you wish to calculate median? ';
result = input(prompt);
median_width=result;
median_halfwidth=result/2
% Check interval for integrating peaks
prompt = 'Over what peak width (in cm) do you want to integrate? ' ;
result = input(prompt);
integ_width=result
integ_halfwidth=result/200
% Find range of ages for calculating median
for i=1:numrows;
millennium(i)=ceil(Age(i)/1000);
agemax(i)=Age(i)+ median_halfwidth;
agemin(i)=Age(i) - median_halfwidth;
end;
% Find rows for age range, but don't allow it outside the range of rows in
% the spreadsheet
for i=1:numrows
 lowindex=i;
 highindex=i;
 while Age(lowindex)>=agemin(i)
     lowindex=lowindex-1;
     if lowindex<1
         break
     end
 end
 while Age(highindex)<=agemax(i)
     highindex=highindex+1;
     if highindex>numrows
         break
     end
 end
 %Make an array with just the parameter (eg sulphate concentration) values 
 %in the chosen age range and calculate the median 
 %The residual is the actual value above the median (baseline)
 median_array=Par_value(lowindex+1:highindex-1);
 % Note that nanmedian, nanmax, nanmin no longer recommended so replaced
 % since earlier version
 median_value(i)= median(median_array, 'omitnan');
 residual_value(i)=Par_value(i)-median_value(i);
 %for EDC_FICsulfate, need correction for calibration issue in top 360 m
 if Depth(i) < 360
    residual_value(i)=residual_value(i)/0.7;
 end
 % Calculate CA/l and CA/l dz (flux)
  CA_over_l(i)=residual_value(i)*Acc_rate(i)/Layer_thickness(i);
  Flux(i)=residual_value(i)*Acc_rate(i)*Sample_thickness(i)/Layer_thickness(i);
end
% Make a transpose so we have a vertical array for a spreadsheet
CA_over_ltranspose=(CA_over_l)';
Fluxtranspose=(Flux)';
mediantranspose=(median_value)';
residualtranspose=(residual_value)';
% unused line next to check intermediate values 
% i, lowindex, highindex, j, median_value (i), residual_value(i), Flux(i)
% Find range of depths for calculating integral of peaks
for i=1:numrows;
depthmax(i)=Depth(i)+ integ_halfwidth;
depthmin(i)=Depth(i) - integ_halfwidth;
end;
% Find rows for depth range, but don't allow it outside the range of rows in
% the spreadsheet
for i=1:numrows
lowindex=i;
highindex=i;
while Depth(lowindex)>=depthmin(i)
    lowindex=lowindex-1;
     if lowindex<1
         break
     end
 end
 while Depth(highindex)<=depthmax(i)
     highindex=highindex+1;
     if highindex>numrows
         break
     end
 end
 % Find max within depth interval 
 max_cA_over_l(i) = max(CA_over_l(lowindex+1:highindex-1),[],'omitnan');
 if max_cA_over_l(i)==CA_over_l(i)
     peaksarray(i)=0;
     for j=lowindex+1:highindex-1
         if Flux(j)>=0
         peaksarray(i)=peaksarray(i)+Flux(j);
         else
         end
     end
 else peaksarray(i)= NaN;
 end
 % Find min within depth interval 
 min_cA_over_l(i) = min(CA_over_l(lowindex+1:highindex-1),[],'omitnan');
 if min_cA_over_l(i)==CA_over_l(i)
     troughsarray(i)=0;
     for j=lowindex+1:highindex-1
         if Flux(j)<=0
         troughsarray(i)=troughsarray(i)+Flux(j);
         else
         end
     end
 else troughsarray(i)= NaN;
 end
end
 max_transpose=(max_cA_over_l)';
 peaksarray_transpose = (peaksarray)';
 min_transpose=(min_cA_over_l)';
 troughsarray_transpose = (troughsarray)';
 mill_transpose = (millennium)';
% Write an output file
folder='c:/leverhulme/matlaboutput/';
%note that NaNs (missing data in Par_value) are in the spreadsheet as
%blanks - needs extra code to put text string {'NaN'} to avoid this
filename = strcat(folder,Site,'_',Param,'_',num2str(median_width),'yr_',num2str(integ_width),'cm.xlsx')
A=[Depth Age Par_value mediantranspose residualtranspose CA_over_ltranspose max_transpose peaksarray_transpose mill_transpose];
writematrix(A, filename);
% A=[Depth Age Par_value CA_over_ltranspose max_transpose peaksarray_transpose mill_transpose];
% xlswrite(filename,A);
% set thresholds for integrated flux
thresh = [1000 2000 5000 10000 20000 30000 40000 50000 60000 75000 100000 200000 300000 400000];
% thresh = [1000 2000 5000 7000 8000 9000 10000 12000 20000];
numthresh=numel(thresh);
% count number of millennia to score (not including last one which is
% incomplete)
nummill = max(millennium);
for i=1:nummill-1
    millcount(i)=i;
    millcount_transpose=millcount';
    % Set counters to zero
for j=1:numthresh
    peakcount(i,j)=0;
    troughcount (i,j)=0;
end
end
% Add up number of peaks above each threshold size in each millennium
for i=1:numrows
    if isfinite(peaksarray(i)) & millennium(i)<nummill
       for j=1:numthresh
          if peaksarray(i)>thresh(j)
               peakcount(millennium(i),j)=peakcount(millennium(i),j)+1;
          end
       end
    end
   % same for the number of troughs bigger than each size range
    if isfinite(troughsarray(i)) & millennium(i)<nummill
       for j=1:numthresh
          if troughsarray(i)<-thresh(j)
               troughcount(millennium(i),j)=troughcount(millennium(i),j)+1;
          end
       end
    end
end
% Total counts in each threshold range for peaks and troughs
for j=1:numthresh
    totalpeak=sum(peakcount);
    totaltrough=sum(troughcount);
end
% Put together a file with counts in each threshold and millennium, for
% peaks and troughs
peakcount1=[NaN thresh;millcount_transpose peakcount;NaN totalpeak];
troughcount1=[NaN thresh;millcount_transpose troughcount;NaN totaltrough];
filename = strcat(folder,Site,'_',Param,'_',num2str(median_width),'yr_',num2str(integ_width),'cm_counts.xlsx')
writematrix(peakcount1, filename)
filename = strcat(folder,Site,'_',Param,'_',num2str(median_width),'yr_',num2str(integ_width),'cm_troughcounts.xlsx')
writematrix(troughcount1, filename)