### Installing the package -----------------------------------------------------
# Install the latest version from Github
#if(!require(devtools)) install.packages("devtools")
#devtools::install_github("mchevalier2/crestr")

# Or the latest stable version from CRAN (Currently submitted)
# install.packages('crestr')



### Preparing the data ---------------------------------------------------------
library(crestr)

setwd('/Users/mchevali1/Manuscripts/Chevalier-crestr/SuppMat')

MD96_2048=read.csv('MD96_2048.csv', check.names=FALSE)
selectedTaxa=read.csv('selectedTaxa.csv', check.names=FALSE, row.names=1)
PSE=read.csv('PSE.csv', check.names=FALSE)



### Downloading the calibration data -------------------------------------------
rcnstrctn <- crest.get_modern_data( df = MD96_2048,
    pse = PSE,
    selectedTaxa = selectedTaxa,
    taxaType = 1,
    climate = c('bio1'), xmn = NA, xmx = NA,
    ymn = -35, ymx = NA,
    continents = 'Africa',
    countries = c('South Africa', 'Kenya', 'Lesotho', 'eSwatini', 'Botswana',
        'Mozambique', 'Zimbabwe', 'Zambia', 'Malawi', 'Tanzania', 'Namibia',
        'Uganda', 'Rwanda', 'Burundi'),
    realms = NA, biomes = NA,
    ecoregions = NA,
    minGridCells = 20,
    site_info = c(34.0167, -26.1667),
    site_name = 'MD96-2048',
    dbname = "gbif4crest_02",
    verbose = TRUE
)

rcnstrctn$misc$taxa_note
#> Theoretical output

#$`No association between the proxy names and species`
# [1] "Liliaceae"                           "Buxus madagascaria-type"
# [3] "Caesalpiniaceae"                     "cf. Laccosperma"
# [5] "Mimosaceae"                          "Monolete psilate"
# [7] "Persicaria senegalensis-type"        "Pteridium type"
# [9] "spores, monolete"                    "Stephanocolporate striatoreticulate"
#[11] "Trilete spores"                      "Varia"
#[13] "Indeterminata"                       "Daisy-type"
#[15] "Asteraceae Liguliflorae"             "Asteraceae Tubuliflorae"
#[17] "Asteraceae Vernoniae"
#
#$`All percentages equal to 0.`
#[1] "Adenia"  "Basella" "Drosera"
#
#$`No correspondance with specific species`
#    Level   Family     Genus Species ProxyName
#216     2 BUXACEAE Notobuxus    <NA> Notobuxus
#
#$`Present but insufficient data in the study area to fit a pdf`
# [1] "Calamus"                  "Raphia-type"
# [3] "Canarium"                 "Allanblackia"
# [5] "Caperonia-type"           "Berlinia-type"
# [7] "Cynometra"                "Flabellaria"
# [9] "Heritiera-type"           "Cephalosphaera"
#[11] "Pycnanthus"               "Pandanus"
#[13] "Cuviera"                  "Gaertnera"
#[15] "Elaeis guineensis"        "Garcinia ovalifolia-type"
#[17] "Lumnitzera-type"
#
#$`No data point available in the study area.`
#[1] "Nypa"                        "Dichostemma-Anthostema-type"
#[3] "Klaineanthus"                "Daniellia-type"
#[5] "Detarium"                    "Lophira"
#[7] "Afraegle"                    "Stipularia africana"



### Calibrating the PDFs -------------------------------------------------------
rcnstrctn <- crest.calibrate(
  rcnstrctn,
  shape = c('normal'),
  climateSpaceWeighting = TRUE,
  bin_width = c(2),
  npoints = 500,
  geoWeighting = TRUE,
  verbose = TRUE
)



### Checking the climate space and climate response ----------------------------
plot_climateSpace(rcnstrctn, save=TRUE,
  filename='Figure 6.png',
  as.png=TRUE, png.res=600,
  width=6.9, height=4.4,
  y0=0.4,
  add_modern=TRUE
)


plot_taxaCharacteristics(rcnstrctn,
  taxanames='Ericaceae', save = TRUE,
  filename = 'Figure 7.png',
  as.png=TRUE, png.res=600,
  width=6.9, height=8.13,
  add_modern=TRUE
)
#> Leave the fields taxanames empty to create a plot for each taxon


#> Random selection of 15 taxa for a simpler visualisation.
tax <- sample(rcnstrctn$input$taxa.name, 15)
plot_violinPDFs(rcnstrctn,
  taxanames = tax,
  save = TRUE,
  filename = 'Figure 8.png',
  as.png=TRUE, png.res=600,
  width = 6.9, height = 3,
  ylim=c(0,30)
)
#> Leave the fields taxanames empty to create the plot with all the taxa (>100)



### Reconstructing climate -----------------------------------------------------
rcnstrctn <- excludeTaxa(rcnstrctn,
  taxa=c('Aizoaceae', 'Chenopodiaceae/Amaranthaceae'),
  climate=c('bio1')
)


rcnstrctn <- crest.reconstruct(
  rcnstrctn,
  presenceThreshold = 0,
  taxWeight = "normalisation",
  verbose = TRUE
)



### Analysing the reconstructions ----------------------------------------------
plot(rcnstrctn,
  filename='Figure 9.png',
  save=TRUE,
  as.png=TRUE, png.res=600,
  width=6.9, height=3.54,
  ylim=c(14,23), uncertainties=c(0.5),
  simplify=FALSE,
  col=plot3D::gg2.col(200)[1:100],
  pt.cex=0.8, pt.lwd=1, pt.col='#2c2c2c'
)


plot(rcnstrctn,
  filename='Figure 9bis.png',
  save=TRUE,
  as.png=TRUE, png.res=600,
  width=6.9, height=3.54,
  ylim=c(14,23), uncertainties=c(0.5, 0.8),
  simplify=TRUE,
  col=plot3D::gg2.col(200)[1:100],
  pt.cex=0.8, pt.lwd=1, pt.col='#2c2c2c'
)


plot_combinedPDFs(rcnstrctn,
    samples=3, only.present=TRUE,
    only.selected=TRUE, save = TRUE,
    filename = 'figure 10.png',
    as.png=TRUE, png.res=600,
    width=6.9, height=3,
    xlim=c(7.5,32.5)
)



### Leave-one-out analysis -----------------------------------------------------

rcnstrctn <- loo(rcnstrctn,
  verbose = TRUE
)


plot_loo(rcnstrctn,
    taxanames=rcnstrctn$inputs$taxa.name[6:25],
    xlim=c(0, 340), save = TRUE,
    filename = 'Figure 11.png',
    as.png=TRUE, png.res=600,
    width=3.5, height=8,
    bar_width=3, col_neg='coral3',
    col_pos='darkcyan'
)



### Exporting and citing the results -------------------------------------------

export(rcnstrctn,
  fullPosterior = TRUE,
  loo = TRUE,
  weights = TRUE,
  pdfs = TRUE
)


cite_crest(rcnstrctn)








MD96_2048=read.csv('/Users/mchevali1/Manuscripts/Chevalier-crestr/SuppMat/MD96_2048.csv', check.names=FALSE)
selectedTaxa=read.csv('/Users/mchevali1/Manuscripts/Chevalier-crestr/SuppMat/selectedTaxa.csv', check.names=FALSE, row.names=1)
PSE=read.csv('/Users/mchevali1/Manuscripts/Chevalier-crestr/SuppMat/PSE.csv', check.names=FALSE)
