% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calib.functions.R
\name{ProxyConversion}
\alias{ProxyConversion}
\title{Convert between Temperature in Degrees C and Proxy Units}
\usage{
ProxyConversion(temperature = NULL, proxy.value = NULL,
  proxy.calibration.type = c("MgCa", "UK37"), point.or.sample = c("point",
  "sample"), n = 1)
}
\arguments{
\item{temperature}{Temperature in degrees C}

\item{proxy.value}{Temperature in proxy units}

\item{proxy.calibration.type}{Type of proxy, e.g. UK37 or MgCa}

\item{point.or.sample}{Use the "best estimate" calibration parameters,
or parameters sampled from the fitted calibration model}

\item{n}{the number of replicate conversions to make in the case of sampled calibration parameters}
}
\value{
a vector of temperatures or proxy values
}
\description{
A wrapper function for accessing proxy - temperature conversion functions
}
\examples{
# From temperature to UK'37
## With fixed calibration
ProxyConversion(temperature = c(1, 2), point.or.sample = "point", proxy.calibration.type = "UK37")

## With random calibration, 5 replicates
ProxyConversion(temperature = c(1, 2), n = 5, point.or.sample = "sample", proxy.calibration.type = "UK37")


## Back-transformation with same calibration
ProxyConversion(proxy.value = as.vector(CalibUK37(temperature = c(21, 22), point.or.sample = "point"))
           , point.or.sample = "point", proxy.calibration.type = "UK37")

## Back-transformation with random calibration
ProxyConversion(proxy.value = as.vector(CalibUK37(temperature = c(21, 22), point.or.sample = "point"))
           , n = 5, point.or.sample = "sample", proxy.calibration.type = "UK37")

## Incompatible arguments
\dontrun{
CalibUK37(temperature = 1, proxy.value = 1)
}
}
\seealso{
Other calib: \code{\link{CalibMgCa}},
  \code{\link{CalibUK37}}
}
