% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ImpulseResponse.R
\name{ImpulseResponse}
\alias{ImpulseResponse}
\title{ImpulseResponse}
\usage{
ImpulseResponse(z, d, z0 = 0)
}
\arguments{
\item{z}{depth relative to focus horizon}

\item{d}{mixing depth. If d == 0, a single weight of 1 is returned}

\item{z0}{depth of the pulse without bioturbation}
}
\value{
Given a vector of depths, \code{z}, relative to a given horizon, the
  function returns a vector of probabilities that a given particle at that
  horizon has been moved there by bioturbation from depth \code{z}
}
\description{
Depth solution for Berger and Heath; e.g. page 65 in Officer and
  Lynch (1983).

  For a given mixing depth \code{d}, it gives the probability
  that a particle has been moved from a depth horizon \code{z} units away
  from the focus horizon.
}
\examples{
z <- seq(-100, 100, length.out = 1000)
d <- 10

plot(z, ImpulseResponse(z, d), type = "l")
abline(v = d)

}
