## ---- eval=FALSE---------------------------------------------------------
#  if (!require("devtools")) {
#    install.packages("devtools")
#  }
#  
#  devtools::install_bitbucket("ecus/sedproxy")

## ----run_shiny, eval=FALSE-----------------------------------------------
#  library(sedproxy)
#  ShinySedproxy()

## ----message = FALSE, warning = FALSE------------------------------------
library(tidyverse)
library(knitr)
library(sedproxy)

## ------------------------------------------------------------------------
N41.proxy.details %>% 
  mutate_if(is.numeric, round, digits = 2) %>% 
  gather() %>% 
  kable(., format = "markdown", digits = 2)

## ------------------------------------------------------------------------
(N41.t21k.climate[1:5,]-273.15) %>% 
  kable(., format = "markdown", digits = 2)

## ------------------------------------------------------------------------
kable(head(N41.proxy), format = "markdown")

## ---- fig.show='hold', warning=FALSE-------------------------------------
set.seed(26052017)
clim.in <- N41.t21k.climate[nrow(N41.t21k.climate):1,] - 273.15

# The input climate signal should be a time series object
# The Trace simulation runs to the year 1990 AD, therefore the start time for 
# the input climate is -39 years BP
clim.in <- ts(clim.in, start = -39)

PFM <- ClimToProxyClim(clim.signal = clim.in,
                       timepoints = round(N41.proxy$Published.age),
                       proxy.calibration.type = "identity",
                       proxy.prod.weights = N41.G.ruber.seasonality,
                       sed.acc.rate = N41.proxy$Sed.acc.rate.cm.ka,
                       meas.noise = 0.46, n.samples = 30,
                       n.replicates = 10)

## ------------------------------------------------------------------------
PFM$everything

## ----default_plot, fig.width=6, fig.height=5.5---------------------------
PFM$everything %>% 
  PlotPFMs(max.replicates = 1)

## ----plot_reps, fig.width=6, fig.height=5.5------------------------------
PFM$everything %>% 
  filter(stage == "simulated.proxy") %>% 
  PlotPFMs(., max.replicates = 5)

## ----MgCa, fig.show='hold', warning=FALSE, echo=FALSE, eval=FALSE--------
#  # ### Proxy types
#  #
#  # The initial input climate signal can be converted into "proxy units" if a `proxy.calibration.type` is specified. This simulates the Environment -> Sensor stage of the proxy system.
#  
#  set.seed(26052017)
#  PFM_2 <- ClimToProxyClim(clim.signal = clim.in,
#                           timepoints = round(N41.proxy$Published.age),
#                           proxy.calibration.type = "MgCa",
#                           proxy.prod.weights = N41.G.ruber.seasonality,
#                           sed.acc.rate = N41.proxy$Sed.acc.rate.cm.ka,
#                           meas.noise = 0.46, n.samples = 30,
#                           n.replicates = 1)

## ----MgCa_plot, fig.width=6, fig.height=5.5, echo=FALSE, eval=FALSE------
#  # `PlotPFM` returns a ggplot2 object so it is easy to customize figures with new axes labels an such
#  
#  PFM_2$everything %>%
#    PlotPFMs(.) +
#    labs(y = "Mg/Ca")

