% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calib.functions.R
\name{CalibMgCa}
\alias{CalibMgCa}
\title{Convert between MgCa and Temperature in degrees C}
\usage{
CalibMgCa(temperature = NULL, proxy.value = NULL,
  point.or.sample = c("point", "sample"), n = 1)
}
\arguments{
\item{temperature}{Temperature in degrees C}

\item{proxy.value}{Temperature in proxy units}

\item{point.or.sample}{Use the "best estimate" calibration parameters,
or parameters sampled from the fitted calibration model}

\item{n}{the number of replicate conversions to make in the case of sampled calibration parameters}
}
\value{
a vector of temperatures or proxy values
}
\description{
Convert between MgCa and Temperature in degrees C
}
\examples{
# From temperature to MgCa
## With fixed calibration
CalibMgCa(temperature = c(1, 2), point.or.sample = "point")

## With random calibration, 5 replicates
CalibMgCa(temperature = c(1, 2), n = 5, point.or.sample = "sample")


## Back-transformation with same calibration
CalibMgCa(proxy.value = as.vector(CalibUK37(temperature = c(21, 22), point.or.sample = "point"))
           , point.or.sample = "point")

## Back-transformation with random calibration
CalibMgCa(proxy.value = as.vector(CalibUK37(temperature = c(21, 22), point.or.sample = "point"))
           , n = 5, point.or.sample = "sample")

## Incompatible arguments
\dontrun{
CalibUK37(temperature = 1, proxy.value = 1)
}
}
\seealso{
Other calib: \code{\link{CalibUK37}},
  \code{\link{ProxyConversion}}
}
