% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClimToProxyClim.dev.R
\name{ClimToProxyClim.dev}
\alias{ClimToProxyClim.dev}
\title{Simulate sediment archived proxy records from an "assumed true" climate signal.}
\usage{
ClimToProxyClim.dev(clim.signal, timepoints,
  proxy.calibration.type = c("identity", "UK37", "MgCa"),
  smoothed.signal.res = 100, proxy.prod.weights = rep(1, 12),
  proxy.prod.args = NULL, bio.depth = 10, sed.acc.rate = 50,
  meas.noise = 0, meas.bias = 0, n.samples = Inf, n.replicates = 1)
}
\arguments{
\item{clim.signal}{The "assumed true" climate signal, e.g. climate model
output or instrumental record. A \code{\link{ts}} object consisting of a
years x 12 (months) x n habitats (e.g. depths) matrix of temperatures. The
time series should be at annual resolution and in reverse, i.e. "most
recent timepoint first" order.}

\item{timepoints}{The timepoints for which the proxy record is to be modelled}

\item{proxy.calibration.type}{Type of proxy, e.g. Uk'37 or MgCa, to which the
clim.signal is converted before the archiving and measurement of the proxy
is simulated}

\item{smoothed.signal.res}{The resolution, in years, of the smoothed (block
averaged) version of the input climate signal returned for plotting. This
does not affect what the proxy model uses as input. If set to NA, no
smoothed climate output is generated, this can speed up some simulations.}

\item{proxy.prod.weights}{Either the seasonal pattern of productivity for the organism(s)
recording / producing the proxy as a vector of 12 values, or a function that
produces an index of productivity as a function of temperature.
Defaults to a uniform seasonal distribution.}

\item{proxy.prod.args}{A named list of parameters to be passed to a function named in proxy.prod.weights}

\item{bio.depth}{Depth of the bioturbated layer in cm, defaults to 10 cm. If
bio.depth == 0, each timepoint samples from a single year of the
clim.signal, equivalent to sampling a laminated sediment core.}

\item{sed.acc.rate}{Sediment accumulation rate in cm per 1000 years. Defaults
to 50 cm per ka. Either a single value, or vector of same length as
"timepoints"}

\item{meas.noise}{The amount of noise to add to each simulated proxy value.
Defined as the standard deviation of a normal distribution with mean = 0}

\item{meas.bias}{The amount of bias to add to each simulated proxy
time-series. Each replicate proxy time-series has a constant bias added,
drawn from a normal distribution with mean = 0, sd = meas.bias. Bias
defaults to zero.}

\item{n.samples}{Number of e.g. Foraminifera sampled per timepoint, this can
be either a single number, or a vector of length = timepoints}

\item{n.replicates}{Number of replicate proxy time-series to simulate from
the climate signal}
}
\value{
\code{ClimToProxyClim} returns a list with three elements:
\enumerate{
\item a dataframe \code{simulated.proxy}
\item a dataframe \code{smoothed.signal}
\item a dataframe \code{everything}
}

The dataframe \code{simulated.proxy} contains a single realisation of the
final forward modelled proxy, as well as the intermediate stages and the
original climate signal at the requested timepoints.

The dataframe \code{smoothed.signal} contains a block averaged version the
input climate signal, defaults to 100 year means but this is set by the
parameter smoothed.signal.res. This is useful for plotting against the
resulting simulated proxy.

The dataframe \code{everything} contains all of the above but with multiple
replicates of the pseudo-proxy records if requested. The data are in
"long form", with the column "stage" inidcating the proxy stage or input
climate resolution and column "value" giving the values.

\strong{Named elements of the returned proxy record:}

\describe{
\item{timepoints}{Requested timepoints}
\item{clim.signal.ann}{Input climate signal at requested timepoints at annual resolution}
\item{clim.signal.smoothed}{Input climate signal at regular time intervals and resolution = smoothed.signal.res}
\item{clim.timepoints.ssr}{Input climate signal at requested timepoints, smoothed to resolution = smoothed.signal.res}
\item{proxy.bt}{Climate signal after bioturbation}
\item{proxy.bt.sb}{Climate signal after bioturbation and production bias}
\item{proxy.bt.sb.inf.b}{Climate signal after bioturbation, production bias, and calibration bias}
\item{proxy.bt.sb.inf.b.n}{Climate signal after bioturbation, production bias, and measurement error}
\item{proxy.bt.sb.sampY}{Climate signal after bioturbation, production bias, and aliasing of inter-annual variation}
\item{proxy.bt.sb.sampYM}{Climate signal after bioturbation, production bias, and aliasing of inter-annual and intra-annual variation such as monthly temperatures or depth habitats}
\item{proxy.bt.sb.sampYM.b}{Climate signal after bioturbation, production bias, and aliasing of inter-annual and intra-annual variation such as monthly temperatures or depth habitats, and calibration bias}
\item{proxy.bt.sb.sampYM.b.n}{Climate signal after bioturbation, production bias, aliasing, and measurement error}
\item{simulated.proxy}{Final simulated pseudo-proxy, this will be same as proxy.bt.sb.inf.b.n when n.samples = Inf, and proxy.bt.sb.sampYM.b.n when n.samples is finite}
\item{observed.proxy}{True observed proxy (when supplied)}
}
}
\description{
Simulate sediment archived proxy records from an "assumed true" climate signal.
}
