% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calib.functions.R
\name{CalibUK37}
\alias{CalibUK37}
\title{Convert between UK'37 and Temperature in degrees C}
\usage{
CalibUK37(temperature = NULL, proxy.value = NULL,
  point.or.sample = c("point", "sample"), n = 1)
}
\arguments{
\item{temperature}{Temperature in degrees C}

\item{proxy.value}{Temperature in proxy units}

\item{point.or.sample}{Use the "best estimate" calibration parameters,
or parameters sampled from the fitted calibration model}

\item{n}{the number of replicate conversions to make in the case of sampled calibration parameters}
}
\value{
a vector of temperatures or proxy values
}
\description{
Convert between UK'37 and Temperature in degrees C
}
\details{
To get the UK'37 calibration parameters
\preformatted{
uk37.dat <- ecusdata::mueller.uk37.sst

lm.uk37 <- lm(`UK'37`~`SST (1-12) [°C]`, data = uk37.dat)

summary(lm.uk37, correlation = TRUE)
}
}
\examples{
# From temperature to UK'37
## With fixed calibration
CalibUK37(temperature = c(1, 2), point.or.sample = "point")

## With random calibration, 5 replicates
CalibUK37(temperature = c(1, 2), n = 5, point.or.sample = "sample")


## Back-transformation with same calibration
CalibUK37(proxy.value = as.vector(CalibUK37(temperature = c(21, 22), point.or.sample = "point"))
           , point.or.sample = "point")

## Back-transformation with random calibration
CalibUK37(proxy.value = as.vector(CalibUK37(temperature = c(21, 22), point.or.sample = "point"))
           , n = 5, point.or.sample = "sample")

## Incompatible arguments
\dontrun{
CalibUK37(temperature = 1, proxy.value = 1)
}
}
\seealso{
Other calib: \code{\link{CalibMgCa}},
  \code{\link{ProxyConversion}}
}
