# Test and compare ts object using version

library(tidyverse)
library(knitr)
library(sedproxy)

set.seed(26052017)
clim.in <- N41.t21k.climate[nrow(N41.t21k.climate):1, ] - 273.15
clim.in <- ts(clim.in, end = 22000)

plot(clim.in[,1], type = "l")

end(clim.in)

PFM <- ClimToProxyClim(clim.signal = clim.in,
                       timepoints = round(N41.proxy$Published.age),
                       proxy.calibration.type = "identity",
                       proxy.prod.weights = N41.G.ruber.seasonality,
                       sed.acc.rate = N41.proxy$Sed.acc.rate.cm.ka,
                       meas.noise = 0.46, n.samples = 30,
                       n.replicates = 10)

PFM$everything

PFM$everything %>%
  PlotPFMs(max.replicates = 1)


