set.seed(26052017)
clim.in <- N41.t21k.climate[nrow(N41.t21k.climate):1,] - 273.15

PFM <- ClimToProxyClim(clim.signal = clim.in,
                       timepoints = 2000,
                       proxy.calibration.type = "identity",
                       proxy.prod.weights = N41.G.ruber.seasonality,
                       meas.noise = 0.46, n.samples = 3000,
                       n.replicates = 1)

library(microbenchmark)
tp <- c(round(N41.proxy$Published.age))
mb = microbenchmark::microbenchmark(
  rel = {
    set.seed(1)
    ClimToProxyClim(clim.signal = clim.in,
                        timepoints = tp,
                        proxy.calibration.type = "identity",
                        proxy.prod.weights = N41.G.ruber.seasonality,
                        meas.noise = 0.46, n.samples = 30,
                        n.replicates = 10)},

  dev = {
    set.seed(1)
    ClimToProxyClim.dev(clim.signal = clim.in,
                        timepoints = tp,
                        proxy.calibration.type = "identity",
                        proxy.prod.weights = N41.G.ruber.seasonality,
                        meas.noise = 0.46, n.samples = 30,
                        n.replicates = 10)}
  , times = 10L)

mb
plot(mb, ylim = c(0, 8e08))
microbenchmark:::autoplot.microbenchmark(mb) +
  expand_limits(x = 0) +
  scale_y_continuous(breaks = c(10, 100, 1000), trans = "identity")
