% This script generates the projection figure, Fig. 5.

t = 2000:2500;

a = 0.44; % cm/K/yr
a1 = 0.1;
a2 = a - a1;
T00 = -0.06/a1; % 0.06 cm/yr is -a1*T00

%dh400 = 2*(a1+a2*exp(-(t-2000)/400));
dh400 = a1*(2-T00)+a2*(2-a1*T00/a2)*exp(-(t-2000)/400);
h400 = cumsum(dh400);
dh400b = 2*(a*exp(-(t-2000)/400));
h400b = cumsum(dh400b);
%dh200 = 2*(a1+a2*exp(-(t-2000)/200));
dh200 = a1*(2-T00)+a2*(2-a1*T00/a2)*exp(-(t-2000)/200);
h200 = cumsum(dh200);
dh200b = 2*(a*exp(-(t-2000)/200));
h200b = cumsum(dh200b);
%dh100 = 2*(a1+a2*exp(-(t-2000)/100));
dh100 = a1*(2-T00)+a2*(2-a1*T00/a2)*exp(-(t-2000)/100);
h100 = cumsum(dh100);
dh100b = 2*(a*exp(-(t-2000)/100));
h100b = cumsum(dh100b);

figure(1)

plot(t, h400, '-k', t, h200, '-r', t, h100, '-b', t, h400b, '--k', t, h200b, '--r', t, h100b,'--b');

legend('tau = 400 yrs', 'tau = 200 yrs', 'tau = 100 yrs', 'location', 'northwest');

print -depsc proj_.eps

