library(ncdf4)
library(maps)

### Read netcdf files 
f1 <- nc_open("EKF400v2.0_ensmean.nc")
lon <- f1$dim[[1]]$vals
lat <- f1$dim[[2]]$vals
temp.jja <- array(NA,dim=c(192,96,10))
for (i in 1695:1704){
 temp.jja[,,i-1694] <- apply(ncvar_get(f1,varid="t2m",start=c(1,1,((i-1602)*12)+6),count=c(-1,-1,3)),c(1,2),mean)
 }
ekf.anom.1695 <- temp.jja[,,1]-apply(temp.jja[,,2:9],1:2,mean)
ekf.st.anom.1695 <- (temp.jja[,,1]-apply(temp.jja[,,2:9],1:2,mean))/apply(temp.jja[,,2:9],1:2,sd)
temp.djf <- array(NA,dim=c(192,96,31,7))
for (i in 1697:1727){
  temp.djf[,,i-1696,] <-ncvar_get(f1,varid="t2m",start=c(1,1,((i-1602)*12)+11),count=c(-1,-1,7))
}
ekf.anom.1698 <- temp.djf[,,1,]-apply(temp.djf[,,2:31,],c(1,2,4),mean)

### plot
mycol <- c("blue4","cornflowerblue","cadetblue2","white","burlywood1","brown1","darkred")
min.lon <- -20
max.lon <- 30
min.lat <- 35
max.lat <- 65
x <- c(lon[lon>180]-360,lon[lon<=180])
y <- rev(lat)
mylevs <-  c(-3.5,-2.5,-1.5,-0.5,0.5,1.5,2.5,3.5)

z <- ekf.anom.1695
z <- rbind(z[lon>180,rev(1:length(lat))],z[lon<=180,rev(1:length(lat))])
filled.contour(x[x>min.lon&x<max.lon],y[y>min.lat&y<max.lat],z[x>min.lon&x<max.lon,y>min.lat&y<max.lat],levels=mylevs,col=mycol,plot.axes={map("world",interior=F,add=T)})

z <- ekf.st.anom.1695
z <- rbind(z[lon>180,rev(1:length(lat))],z[lon<=180,rev(1:length(lat))])
filled.contour(x[x>min.lon&x<max.lon],y[y>min.lat&y<max.lat],z[x>min.lon&x<max.lon,y>min.lat&y<max.lat],levels=mylevs,col=mycol,plot.axes={map("world",interior=F,add=T)})

mylevs <-  c(-5.6,-4,-2.4,-0.8,0.8,2.4,4,5.6)
z <- ekf.anom.1698[,,1]
z <- rbind(z[lon>180,rev(1:length(lat))],z[lon<=180,rev(1:length(lat))])
filled.contour(x[x>min.lon&x<max.lon],y[y>min.lat&y<max.lat],z[x>min.lon&x<max.lon,y>min.lat&y<max.lat],levels=mylevs,col=mycol,plot.axes={map("world",interior=F,add=T)})
z <- ekf.anom.1698[,,2]
z <- rbind(z[lon>180,rev(1:length(lat))],z[lon<=180,rev(1:length(lat))])
filled.contour(x[x>min.lon&x<max.lon],y[y>min.lat&y<max.lat],z[x>min.lon&x<max.lon,y>min.lat&y<max.lat],levels=mylevs,col=mycol,plot.axes={map("world",interior=F,add=T)})
z <- ekf.anom.1698[,,3]
z <- rbind(z[lon>180,rev(1:length(lat))],z[lon<=180,rev(1:length(lat))])
filled.contour(x[x>min.lon&x<max.lon],y[y>min.lat&y<max.lat],z[x>min.lon&x<max.lon,y>min.lat&y<max.lat],levels=mylevs,col=mycol,plot.axes={map("world",interior=F,add=T)})
z <- ekf.anom.1698[,,4]
z <- rbind(z[lon>180,rev(1:length(lat))],z[lon<=180,rev(1:length(lat))])
filled.contour(x[x>min.lon&x<max.lon],y[y>min.lat&y<max.lat],z[x>min.lon&x<max.lon,y>min.lat&y<max.lat],levels=mylevs,col=mycol,plot.axes={map("world",interior=F,add=T)})
z <- ekf.anom.1698[,,5]
z <- rbind(z[lon>180,rev(1:length(lat))],z[lon<=180,rev(1:length(lat))])
filled.contour(x[x>min.lon&x<max.lon],y[y>min.lat&y<max.lat],z[x>min.lon&x<max.lon,y>min.lat&y<max.lat],levels=mylevs,col=mycol,plot.axes={map("world",interior=F,add=T)})
z <- ekf.anom.1698[,,6]
z <- rbind(z[lon>180,rev(1:length(lat))],z[lon<=180,rev(1:length(lat))])
filled.contour(x[x>min.lon&x<max.lon],y[y>min.lat&y<max.lat],z[x>min.lon&x<max.lon,y>min.lat&y<max.lat],levels=mylevs,col=mycol,plot.axes={map("world",interior=F,add=T)})
z <- ekf.anom.1698[,,7]
z <- rbind(z[lon>180,rev(1:length(lat))],z[lon<=180,rev(1:length(lat))])
filled.contour(x[x>min.lon&x<max.lon],y[y>min.lat&y<max.lat],z[x>min.lon&x<max.lon,y>min.lat&y<max.lat],levels=mylevs,col=mycol,plot.axes={map("world",interior=F,add=T)})

