function [h,p,p_crit]=chi2test2(x,y,alpha,varargin)
%Pearson chi^2 test

%% Formating input fields
fields=reshape(varargin,2,size(varargin,2)/2);
fields=cell2struct(fields(2,:),fields(1,:),2);
verbage=0; if isfield(fields,'verbage');verbage=fields.verbage;end;

%% Check Inputs
if nargin< 2 + length(varargin) 
    error(message('stats:chi2test2:TooFewInputs'));
end
if nargin < 3 + length(varargin)|| isempty(alpha)
    alpha = 0.05;
elseif ~isscalar(alpha) || alpha <= 0 || alpha >= 1
    error(message('stats:chi2test2:BadAlpha'));
end

xnan=isnan(x);
ynan=isnan(y); 
x=x(~xnan & ~ynan);y=y(~xnan & ~ynan);   
if ~isvector(x) || ~isvector(y) || ~isequal(size(x),size(y))
    error('X/Y intputs must be vectors of equal length');
end

%%
N=numel(x);
DoF=N-2;

chi_2=nansum((y-x).^2./abs(x));
chi_2_crit=chi2inv(alpha,DoF);

if verbage
    if chi_2<chi_2_crit
        fprintf(['\nH_0 true:  Unable to reject equality of X & Y at significance ' num2str(100*alpha) '%%.\n'])
    else
        fprintf(['\nH_0 rejected:  X & Y are not equal at significance ' num2str(100*alpha) '%%.\n'])
    end
end

%% Output
h=chi_2>chi_2_crit;
p=chi_2;
p_crit=chi_2_crit;