#Function opt_linterp
opt_linterp<-function(data2col,dtmoy,ndigits) {
  library(astrochron)
  lev   = data2col[,1]
  sig   = data2col[,2]

  # Criterion 3: least absolute sum of area of the differences between the two curves
  itnum      = dtmoy/10^(-ndigits)
  datIntMax  = linterp(data2col,dt=10^(-ndigits),start=min(lev),genplot=F,verbose=F)
  sumdiffs   = rep(0,times=itnum)
  xstart     = seq(from=min(lev),to=(min(lev)+itnum*10^(-ndigits)),by=10^(-ndigits))
  for (i in 1:itnum) {
    datIntI      = linterp(data2col,dtmoy,start=xstart[i],genplot=F,verbose=F)
    datIntI2     = linterp(datIntI,10^(-ndigits),start=xstart[i],genplot=F,verbose=F)
    datIntMaxCmp = datIntMax[i:(length(datIntI2[,1])+i-1),]
    diffCurves   = abs(datIntI2[,2]-datIntMaxCmp[,2])
    sumdiffs[i]  = sum(diffCurves)/nrow(datIntI2)
  }

  IndOpt         = which.min(sumdiffs)
  xStartOpt      = xstart[IndOpt]
  datIntOpt      = linterp(data2col,dtmoy,start=xStartOpt,genplot=F,verbose=F)
  
  return(datIntOpt)
}

