close all
clearvars

RTime=38;

Names_LO={'Land','Shallow','Seas','Oceans'}; Nn=length(Names_LO);

lon=-179.95:0.1:179.95;
lat=-89.95:0.1:89.95;
[Lon,Lat]=meshgrid(lon,lat);
[Nlat,Nlon]=size(Lon);

Mask_LO=zeros(Nlat,Nlon);

for in=1:Nn
    
    disp(['Starting ' Names_LO{in}])
    Folder=[Names_LO{in} num2str(RTime) 'Ma/'];
    Name=['reconstructed_' num2str(RTime) 'Ma.shp'];
    
    fMask=false(Nlat,Nlon);
    
    D=shaperead([Folder Name]); Nf=length(D);
    
    for i=1:Nf
        outline=inpolygon(Lon,Lat,D(i).X,D(i).Y);
        fMask=fMask|outline;
    end
    
    Mask_LO(fMask)=in;
    
    disp(['Finished ' Names_LO{in}])
end

Mask_Topo=zeros(Nlat,Nlon);

disp('Starting Topo Masks')

D=shaperead(['TopoMasks' num2str(RTime) '/reconstructed_' num2str(RTime) 'Ma.shp']); Nf=length(D);
Tindex=[4 1 3 2];

for i=1:Nf
    outline=inpolygon(Lon,Lat,D(Tindex(i)).X,D(Tindex(i)).Y);
    Mask_Topo(outline)=i;
end

disp('Finished Topo Masks')

LOMap=[0.5 0.5 0.5;1 1 1;0 1 1;0 0 1;0 0 0];
TopoMap=[0.5 0.5 0.5;1 1 0;0 0.5 0;1 0.5 0;1 0 0];
lonlab={'180W','150W','120W','90W','60W','30W','0','30E','60E','90E','120E','150E','180E'};
latlab={'80S','60S','40S','20S','0','20N','40N','60N','80N'};

scrsz = get(0,'ScreenSize');
h=figure('Position',[scrsz(3)/6 scrsz(4)/4 2*scrsz(3)/3 2*scrsz(4)/3]);
axes('Position',[0.05 0.05 0.9 0.9])
imagesc(lon,lat,Mask_LO); set(gca,'ydir','normal')
colormap(LOMap)
set(gca,'Xlim',[-180 180]); set(gca,'Ylim',[-90 90])
set(gca,'XTick',-180:30:180); set(gca,'YTick',-80:20:80)
set(gca,'XTickLabel',lonlab); set(gca,'YTickLabel',latlab)
grid
set(gcf,'paperunits','inches')
set(gcf,'paperposition',[0 0 10 6])
print(h,'-dpng','-r300',['Figures/LOMask_gridded' num2str(RTime)])

close

h=figure('Position',[scrsz(3)/6 scrsz(4)/4 2*scrsz(3)/3 2*scrsz(4)/3]);
axes('Position',[0.05 0.05 0.9 0.9])
imagesc(lon,lat,Mask_Topo); set(gca,'ydir','normal')
colormap(TopoMap)
set(gca,'Xlim',[-180 180]); set(gca,'Ylim',[-90 90])
set(gca,'XTick',-180:30:180); set(gca,'YTick',-80:20:80)
set(gca,'XTickLabel',lonlab); set(gca,'YTickLabel',latlab)
grid
set(gcf,'paperunits','inches')
set(gcf,'paperposition',[0 0 10 6])
print(h,'-dpng','-r300',['Figures/TopoMask_gridded' num2str(RTime)])

close

ncid = netcdf.create(['Files/Masks' num2str(RTime) '.nc'],'NC_WRITE');
dimidlat = netcdf.defDim(ncid,'latitude',Nlon);
dimidlon = netcdf.defDim(ncid,'longitude',Nlat);
latitude_ID=netcdf.defVar(ncid,'latitude','double',dimidlat);
longitude_ID=netcdf.defVar(ncid,'longitude','double',dimidlon);
MLO_ID = netcdf.defVar(ncid,'Mask_LO','byte',[dimidlon dimidlat]);
MT_ID = netcdf.defVar(ncid,'Mask_Topo','byte',[dimidlon dimidlat]);
netcdf.endDef(ncid);
netcdf.putVar(ncid,latitude_ID,lon);
netcdf.putVar(ncid,longitude_ID,lat);
netcdf.putVar(ncid,MLO_ID,Mask_LO);
netcdf.putVar(ncid,MT_ID,Mask_Topo);
netcdf.close(ncid)
