close all
clearvars

RTime=38;

Names={'ShallowSeas','ContinentalShelves_exp','Coastlines'}; Nn=length(Names);

lon=-179.95:0.1:179.95;
lat=-89.95:0.1:89.95;
[Lon,Lat]=meshgrid(lon,lat);
[Nlat,Nlon]=size(Lon);

Mask=zeros(Nlat,Nlon);

for in=1:Nn
    
    disp(['Starting polygons ' Names{in}])
    Folder=[Names{in} '/reconstructed_' num2str(RTime) 'Ma/'];
    Name=['reconstructed_' num2str(RTime) 'Ma_polygon.shp'];
    
    fMask=false(Nlat,Nlon);
    
    D=shaperead([Folder Name]); Nf=length(D);
    
    for i=1:Nf
        outline=inpolygon(Lon,Lat,D(i).X,D(i).Y);
        fMask=fMask|outline;
    end
    
    disp(['Starting polylines ' Names{in}])
    Name=['reconstructed_' num2str(RTime) 'Ma_polyline.shp'];
    
    D=shaperead([Folder Name]); Nf=length(D);
    
    for i=1:Nf
        outline=inpolygon(Lon,Lat,D(i).X,D(i).Y);
        fMask=fMask|outline;
    end
    
    Mask(fMask)=in;
    
    disp(['Finished ' Names{in}])
end

MaskMap=[0.5 0.5 0.5;0 0 0;0 0 1;1 1 1];
lonlab={'180W','150W','120W','90W','60W','30W','0','30E','60E','90E','120E','150E','180E'};
latlab={'80S','60S','40S','20S','0','20N','40N','60N','80N'};

scrsz = get(0,'ScreenSize');
h=figure('Position',[scrsz(3)/6 scrsz(4)/4 2*scrsz(3)/3 2*scrsz(4)/3]);
axes('Position',[0.05 0.05 0.9 0.9])
imagesc(lon,lat,Mask); set(gca,'ydir','normal')
colormap(MaskMap)
set(gca,'Xlim',[-180 180]); set(gca,'Ylim',[-90 90])
set(gca,'XTick',-180:30:180); set(gca,'YTick',-80:20:80)
set(gca,'XTickLabel',lonlab); set(gca,'YTickLabel',latlab)
grid
set(gcf,'paperunits','inches')
set(gcf,'paperposition',[0 0 10 6])
print(h,'-dpng','-r300',['Figures/Boundaries_gridded' num2str(RTime)])

close

ncid = netcdf.create(['Files/Boundaries' num2str(RTime) '.nc'],'NC_WRITE');
dimidlat = netcdf.defDim(ncid,'latitude',Nlon);
dimidlon = netcdf.defDim(ncid,'longitude',Nlat);
latitude_ID=netcdf.defVar(ncid,'latitude','double',dimidlat);
longitude_ID=netcdf.defVar(ncid,'longitude','double',dimidlon);
M_ID = netcdf.defVar(ncid,'Mask','byte',[dimidlon dimidlat]);
netcdf.endDef(ncid);
netcdf.putVar(ncid,latitude_ID,lon);
netcdf.putVar(ncid,longitude_ID,lat);
netcdf.putVar(ncid,M_ID,Mask);
netcdf.close(ncid)