# Author: Joe Werner
###############################################################################

MakeWSLIndex <- function(wslfilename){
	#Bframe <- read.fwf(con <- file("../wsl-indices-sitelist.txt"), widths=c(5,2,9,1,9,1,7,1,25,1,4,1,4,2,9,2,2,2,1,3,2,1,1,4,1,3), skip=7)	
	Bframe <- read.fwf(con <- wslfilename, widths=c(5,11,10,8,27,5,4,6,1,4,4,2,1,3,2,1,5,4),skip=7)
	
	SiteList <- list(Bframe[[2]], Bframe[[3]], Bframe[[4]], Bframe[[5]],
			Bframe[[6]], Bframe[[7]], Bframe[[8]])
	
	Bframe[[11]][is.na(Bframe[[11]])] <- 0
	LatitudeNorth <- (Bframe[[11]]+Bframe[[12]]/60)*(as.numeric(sub("N","2",sub("S","0",Bframe[[13]])))-1);
	Bframe[[14]][is.na(Bframe[[14]])] <- 0
	LongitudeEast <- (Bframe[[14]]+Bframe[[15]]/60)*(as.numeric(sub("E","2",sub("W","0",Bframe[[16]])))-1);
	
	SiteList[[8]] <- cbind( LatitudeNorth, LongitudeEast);
	SiteList[[9]] <- Bframe[[17]];
	SiteList[[10]] <- Bframe[[18]];
	
	names(SiteList) <- c("Filename", "Ident", "Short",
			"local", "country", "Species", "StartYear", "Coordinates", "Altitude",
			"Exposition");
	
	return(SiteList)
}

ReturnCoordinates <- function( filename, SiteList ){
	pathtofile <- strsplit(filename, "/");
	filename <- toupper(sub("_hcr.txt", "", pathtofile[[1]][length(pathtofile[[1]])] ));
	print(filename);
	
	IDX <- grep(paste(filename,"[[:space:]]",sep=""), SiteList$Filename, ignore.case=TRUE)
	
	if(length(IDX) == 0){ return(-1); break}
	return(SiteList$Coordinates[IDX,]);
}

Read.WSLfile <- function( filename, is.rawdata){
	if( is.rawdata ){ divisor <- 100 } else { divisor <- 1000 };
	Aframe <- read.fwf(con <- filename, widths=c(8, 4, rep(4,18), rep(4,2), 24))
	Aframe <- Aframe[-dim(Aframe)[1]];
	Aframe[ Aframe == -999] <- NA;
	#close(con);
	startyear <- Aframe[1,3];
	species <- Aframe[1,21];
	totalwidth <- Aframe[13]/divisor;
	latewood <- Aframe[7]/divisor;
	WSL.Data <- list(filename, startyear, species, totalwidth, latewood);
	names(WSL.Data) <- c("Filename", "StartYear", "Species", "TW", "MXD");
	return (WSL.Data);
}
