# This reads a .crn file as specified on
# http://www.ncdc.noaa.gov/paleo/treeinfo.html
# into a list conaining the following fields
#
# site		: [site name, country, site ID]
# species	: [species code, species name]
# elevation	: elevation
# latlon	: [latitude, longitude] 
#			  in degrees and decimal parts NOT IN arcmin and arcsec
# timespan	: [first year, last year]
# data		: data as an array
# 
# Author: Joe Werner
###############################################################################

ReadCRNtoList <- function(filename){
	Header <- readLines(con <- file(filename),3);
	close(con);
	dummy <- vector(mode="character");
	dummy[1] <- substr(Header[1],10,61);
	dummy[2] <- substr(Header[2],10,21);
	dummy[3] <- substr(Header[1],1,6);
	
	returnlist <- list(dummy);
	
	dummy <- vector(mode="character");
	dummy[1] <- substr(Header[1],62,65);
	dummy[2] <- substr(Header[2],23,40);
	
	returnlist[[2]] <- c(dummy);
	
	returnlist[[3]] <- strtoi(substr(Header[2],41,44),base=10);
	
	dummy <- vector();
	dummy[1] <- strtoi(substr(Header[2],48,49),base=10);
	dummy[2] <- strtoi(substr(Header[2],50,51),base=10);
	dummy[3] <- dummy[1] + dummy[2]/60;
	
	dummy[4] <- strtoi(substr(Header[2],53,55),base=10);
	dummy[5] <- strtoi(substr(Header[2],56,57),base=10);
	dummy[6] <- dummy[4] + dummy[5]/60;
	
	returnlist[[4]] <- matrix(c(dummy[3], dummy[6]));
	
	dummy <- vector();
	dummy[1] <- strtoi(substr(Header[2],68,71),base=10);
	dummy[2] <- strtoi(substr(Header[2],73,76),base=10);
	
	returnlist[[5]] <- matrix(c(dummy[1], dummy[2]));
	
	returnlist[[6]] <- read.crn(filename);
	
	names(returnlist) <- c("site", "species", "elevation", "latlon", "timespan", "data");
	
	return(returnlist);
}