NormaliseData <- function(datafile){
# This reads the data given in $datafile and normalises it to zero mean
# and standard deviation of one.
# Expected format:
# The file should contain the variable BARCAST.INPUT as used in the
# BARCAST code
  load(datafile)
  N.T <- length(BARCAST.INPUT$Inst.Data[,1])
  N.L <- length(BARCAST.INPUT$Inst.Data[1,])

  InstMean <- colMeans(BARCAST.INPUT$Inst.Data, na.rm=TRUE);
  BARCAST.INPUT$Inst.Data <- BARCAST.INPUT$Inst.Data - matrix(InstMean, nrow=N.T, ncol=N.L, byrow=TRUE);
  InstSD <- sd(BARCAST.INPUT$Inst.Data, na.rm=TRUE)
  BARCAST.INPUT$Inst.Data <- BARCAST.INPUT$Inst.Data/matrix(InstSD, nrow=N.T, ncol=N.L, byrow=TRUE);
  
  Inst.Adjust <- list();
  Inst.Adjust[[1]] <- InstMean;
  Inst.Adjust[[2]] <- InstSD;
  names(Inst.Adjust) <- c("Mean", "SDev");

  pname <- "Prox\\.Data\\."
  PIdx <- which(regexpr(pname, names(BARCAST.INPUT)) == 1);
  
  ADJUSTMENTS <- list();
  ADJUSTMENTS$Inst <- Inst.Adjust;

  for (PNum in PIdx){
    ProxyMean <- colMeans(BARCAST.INPUT[[PNum]], na.rm=TRUE);
    BARCAST.INPUT[[PNum]] <- BARCAST.INPUT[[PNum]] - matrix(ProxyMean, nrow=N.T, ncol=N.L, byrow=TRUE);
    ProxySD <- sd(BARCAST.INPUT[[PNum]], na.rm=TRUE)
    BARCAST.INPUT[[PNum]] <- BARCAST.INPUT[[PNum]]/matrix(ProxySD, nrow=N.T, ncol=N.L, byrow=TRUE);
    
    Proxy.Adjust <- list();
    Proxy.Adjust[[1]] <- ProxyMean;
    Proxy.Adjust[[2]] <- ProxySD;
    names(Proxy.Adjust) <- c("Mean", "SDev");
    pname <- paste("Prox.Data.", PNum, sep="")
    ADJUSTMENTS[[length(ADJUSTMENTS) + 1]] <- Proxy.Adjust;
    names(ADJUSTMENTS)[length(ADJUSTMENTS)] <- pname;
  }

  BaseFileName <- gsub(".R$","",datafile);
  save(BARCAST.INPUT, file=paste(BaseFileName, "normal.R", sep="_"))
  save(ADJUSTMENTS, file=paste(BaseFileName, "adjust.R", sep="_"))
}
