# load("trueADM/BARCASTINPUT_full_true.RData")

# Create and store a list of the correct ADMs for all proxies, they should be
# the same for all experiments done! This facilitates comparison across
# experiments, parameter selections, proxy lengths used etc.
#load("trueADM.RData")
ADM.TRUE <- list()
for ( thisProx in seq(length(ADMs)) ){
  if( length(ADMs[[ thisProx]]) > 1){
    ADM.TRUE[[ thisProx]] <- trueADM
  } else {
    ADM.TRUE[[ thisProx]] <- NA
  }
}

add.alpha <- function(col, alpha=1){
  if(missing(col))
    stop("Please provide a vector of colours.")
  apply(sapply(col, col2rgb)/255, 2, 
          function(x) rgb(x[1], x[2], x[3], alpha=alpha))  
}


PlotADMdist <- function( targetDir, targetFile=NA, nChains = NA){
  # Remove the first 3rd of the iterations!
  # First evaluate the experiment w/ the true ADM present
  if( is.na( targetFile)){ targetFile <- dir(targetDir,pattern="^BARCASTINPUT") }
  load( targetFile)
  load(paste(targetDir,"Parameters_1_thin.RData",sep="/"))
  if( is.na( nChains)) { nChains <- length( dir(targetDir,pattern="^[0-9]+")) }
  nPar   <- dim( Parameters.Chains)[1]/nChains
  nIts   <- dim( Parameters.Chains)[2]
  # Create a matrix where to store the temperatures, later sort them and use
  # this information to rearrange the chains by temperatures. Then, actually
  # evaluate the results of the run.
  TempMat <- Parameters.Chains[7+(0:(nChains-1))*nPar,]
  TempSort <- matrix(unlist(
              apply( TempMat,2,sort,index.return=TRUE,decreasing=TRUE)
            ),nChains)[,seq(2,2*dim(Parameters.Chains)[2],2)]

  Parameters.Sorted <- NA*Parameters.Chains
  for( a in seq( dim(Parameters.Chains)[2])){
    Parameters.Sorted[,a] <- Parameters.Chains[rep((TempSort[,a]-1)*nPar,each=nPar) +rep(1:nPar,times=nChains) ,a]
  }
  Parameters.Sorted <- Parameters.Sorted[,(nIts/3):nIts] 
  # the first seven are the process model parameters, we're not interested in that.
  # We want to assess the proxy model parameters, especially those of proxies with
  # time uncertainty.
  N.PT <- (nPar-7)/5
  MyPal <- add.alpha( RColorBrewer::brewer.pal( nChains, "OrRd"), .9)
  for( thisProx in seq(N.PT)){
    if( Parameters.Sorted[3+thisProx*5,1] == 20){
      ADMs[[ thisProx]]$trueADM <- ADM.TRUE[[ thisProx]]
      ADMs[[ thisProx]]$ADMdist <- colMeans( abs(ADMs[[thisProx]]$adm-ADMs[[thisProx]]$trueADM) )
    }
  }

  pdf( width=12,height=5, file=paste(targetDir,"ADMs.pdf",sep="/"))
  plot( NA, ylim=c(-15,15), xlim=c(1,1301), xlab="layer from top", ylab="mismatch",main="all ADMs")
  for(thisADM in seq(length(ADMs[[1]]$adm[1,]))){
    lines( rev(ADMs[[1]]$adm[,thisADM]-trueADM), col=rgb(0,0,0,.2) )
  }
  shortdist <- sort(ADMs[[1]]$ADMdist,index.return=TRUE)$ix[1:20]
  plot( NA, ylim=c(-15,15), xlim=range(trueADM), xlab="layer from top", ylab="mismatch",main="closest 20")
  for(thisADM in seq(length(ADMs[[1]]$adm[1,]))){
    lines( rev(ADMs[[1]]$adm[,thisADM]-trueADM), col=rgb(0,0,0,.1) )
  }
  for(thisADM in shortdist){lines( rev(ADMs[[1]]$adm[,thisADM]-trueADM), col="red")}
  for( thisProx in seq(N.PT)){
    if( Parameters.Sorted[3+thisProx*5,1] == 20){
#      ADMs[[ thisProx]]$trueADM <- ADM.TRUE[[ thisProx]]
#      ADMs[[ thisProx]]$ADMdist <- colMeans( abs(ADMs[[thisProx]]$adm-ADMs[[thisProx]]$trueADM) )
      par( mfrow=c(1,2))
      PriorHist <- hist(ADMs[[ thisProx]]$ADMdist,25,main=paste("ADM distances,
        proxy",thisProx),xlab="L1 distance")
      ProxHist <- list()
      histlim <- c()
      for( thisChain in seq(nChains)){
        ProxHist[[thisChain]] <- hist( breaks=PriorHist$breaks, ADMs[[ thisProx]]$ADMdist[
            Parameters.Sorted[3+thisProx*5+4+(thisChain-1)*nPar,] ], plot=FALSE)
        histlim <- c(histlim,ProxHist[[thisChain]]$counts)
      }
      plot( NA, xlab="L1 distance", ylab="Frequency",
        xlim=range(ADMs[[ thisProx]]$ADMdist[Parameters.Sorted[7+thisProx*5+(1:nChains-1)*nPar,]]),
        ylim=range(histlim) )
      for( thisChain in rev(seq(nChains) )){
        plot( ProxHist[[thisChain]], col=MyPal[thisChain], add=TRUE)
      }
      par( mfrow=c(1,2))
      plot( NA, xlim=c(0,dim(Parameters.Sorted)[2]),
        ylim=range(ADMs[[thisProx]]$ADMdist[Parameters.Sorted[7+thisProx*5+(1:nChains-1)*nPar,] ]),
        main=paste("transient model selection, by distance, proxy",thisProx),
        ylab="L1 distance", xlab="draw number", type="l")
      for( thisChain in seq(nChains)){
        lines(ADMs[[ thisProx]]$ADMdist[
            Parameters.Sorted[3+thisProx*5+4+(thisChain-1)*nPar,] ], col= thisChain)
      }
      plot( NA, xlim=c(0,dim(Parameters.Sorted)[2]),
        ylim=range(Parameters.Sorted[7+thisProx*5+(1:nChains-1)*nPar,]),
        main=paste("transient model selection, by model, proxy",thisProx),
        ylab="model number", xlab="draw number", type="p", pch=".")
      for( thisChain in seq(nChains)){
        points(Parameters.Sorted[7+thisProx*5+(thisChain-1)*nPar,], pch=".", col= thisChain)}
    }
  }
  unc.Prox <- which( Parameters.Sorted[7+(1:N.PT-1)*5+1,1] == 20)
  for( thisChain in seq(nChains)){
    #ProxHist <- list()
    #plot( NA, xlim=range(ADMs[[ unc.Prox[1]]]$ADMdist[
    #                Parameters.Sorted[7+unc.Prox*5+(thisChain-1)*nPar,]]), ylim=c(0,6000))
    #for( thisProx in unc.Prox){
    #  ProxHist[[thisChain]] <- hist(ADMs[[ thisProx]]$ADMdist[
    #      Parameters.Sorted[3+thisProx*5+4+(thisChain-1)*nPar,] ], plot=FALSE)
    #  plot( ProxHist[[thisChain]], col=rgb(1-thisChain/nChains,0,thisChain/nChains,.5), add=TRUE)
    #}
    par( mfrow=c(1,2))
    plot( NA, xlim=c(0,dim(Parameters.Sorted)[2]),
          ylim=range(ADMs[[1]]$ADMdist[Parameters.Sorted[7+(unc.Prox-1)*5+5+(1:nChains-1)*nPar,] ]),
          main=paste("transient model selection, by distance, chain no.",thisChain),
          ylab="L1 distance", xlab="draw number", type="l")
    for( thisProx in unc.Prox){
      lines(ADMs[[ thisProx]]$ADMdist[
            Parameters.Sorted[3+thisProx*5+4+(thisChain-1)*nPar,] ], col= thisProx)
    }
    plot( NA, xlim=c(0,dim(Parameters.Sorted)[2]),
          ylim=range(Parameters.Sorted[7+(unc.Prox-1)*5+5+(1:nChains-1)*nPar,]),
          main=paste("transient model selection, by model, chain no.",thisChain),
          ylab="model number", xlab="draw number", type="l")
    for( thisProx in unc.Prox){
      points(Parameters.Sorted[3+thisProx*5+4+(thisChain-1)*nPar,], col=thisProx, pch=".")
    }
  }
  par( mfrow=c(1,1))
  for( thisProx in unc.Prox){
    plot( NA, ylim=c(-15,15), xlim=range(trueADM), xlab="layer from top", ylab="mismatch",main="Selected, Posterior > Prior")
    ADMHist <- hist(Parameters.Sorted[3+thisProx*5+4,],dim(ADMs[[thisProx]]$adm)[2]+1,plot=FALSE)
    PostIdx <- which(ADMHist$counts > length( Parameters.Sorted[3+thisProx*5+4,])/dim(ADMs[[thisProx]]$adm)[2] )
    for(thisADM in seq(length(ADMs[[thisProx]]$adm[1,]))){
      lines( rev(ADMs[[1]]$adm[,thisADM]-trueADM), col=rgb(0,0,0,.1) )
    }
    for(thisADM in PostIdx){lines( rev(ADMs[[thisProx]]$adm[,thisADM]-trueADM), col="blue")}
    for(thisADM in shortdist){lines( rev(ADMs[[1]]$adm[,thisADM]-trueADM), col="red", lty=2)}
  }

  dev.off()
  save(list=c("Parameters.Sorted","TempSort","TempMat"), file="SortChains.RData")
}


