# TODO: Add comment
# 
# Author: Martin Tingley, Joe Werner (R adaption)
###############################################################################

#  tidy up workspace
rm(list=ls())

#BARCAST.wd="c:/Dokumente\ und\ Einstellungen/Petra/Eigene\ Dateien/Johannes/workspace/BARCAST/"
BARCAST.wd=getwd();
setwd(BARCAST.wd);

library("MASS");
source("./Common.R");

## MAKE some data to test the new BARCAST coding
#SIMPLIFY - A proxy and and inst data matrix, the same number of rows
#(locations) as the Temperature Matrix we want to estimate, one less column
#(years), as the Temperature Matrix includes a year zero.  Fill the missing
#observations with NaNs 

#		clear all; close all
# Need, realistically, more variables than years/records, but we do not
# want many of each so this will run fast. 
# Start with nine, located at ({-1,0,1}, {-1,0,1}). BARCAST requires the
# locations, even though RegEM does not. 
		
#THINK OF THESE AS ARRAYED ON THE EQUATOR, one degree of lon apart from one another
#LON-LAT
EarthRad=6378.137;
locs<-matrix(NA, 0, 2);
for (i in seq(0,15,5)){
	for (j in seq(40,65,5)){
		locs <- rbind(locs, c(i,j));
	}
}
N<-length(locs[,1]); #number of locations. 

N.Recs<- 1001; #=number of years
timeline<-c(seq(0,N.Recs-1));
dist.mat<-EarthDistances(locs);

#SET the values of the eight scalar parameters:
alpha <- 0.6;
mu <- 0;
sig2 <- 1.25;
phi <- 0.0015;
tau2.I <- 0.10;
tau2.P <- 1.60; #recall they are in different units
Beta.1 <- 1;#0.75;
Beta.0 <- -.5;#-0.5;
	
tau2.P.2=1.50; #recall they are in different units
Beta.1.2=2;#0.75;
Beta.0.2=0;#-0.5;
		
		
# Make them into a big vector
Pars.TRUE<-c(alpha, mu, sig2, phi, tau2.I, tau2.P, Beta.1, Beta.0, tau2.P.2, Beta.1.2, Beta.0.2);
		
#Spatial covariance matrix
spat.cov<-sig2*exp(-dist.mat*phi);
#we need the square root of this: 
#sqrt.spat.cov<-spat.cov^(1/2);
		
#Make the blank data matrix:
Temperature.Matrix<-matrix(NA,N.Recs, N);
#fill the first value
Temperature.Matrix[1,]<-sqrt(1/(1-alpha^2))*mvrnorm(1,rep(mu,N),spat.cov);
		
#fill it in
for (KK in seq(2,N.Recs) ){
	Temperature.Matrix[KK,]<-alpha*Temperature.Matrix[KK-1,]+(1-alpha)*mu+mvrnorm(1,rep(0,N),spat.cov);
}
		
		## pLOT THE DATA:
#		figure(20), clf
#		sep=5;
#		set(gca, 'fontsize', 14)
#		for (kk in seq(1:N)){
		#  plot(timeline,  Temperature.Matrix[,kk]+(kk-1)*sep)#, 'ko-', 'LineWidth', 2, 'MarkerSize', 4), hold on
#		  plot(timeline, zeros(N_Recs,1)+(kk-1)*sep, 'k--', 'linewidth', 1.5, 'color', [0.7, 0.7, 0.7], 'MarkerSize', 3), hold on
#		  text(timeline(end)+0.75, (kk-1)*sep, ['[', num2str(locs(kk,1)), ', ', num2str(locs(kk,2)), ']'], 'fontsize', 14)
#		}
#		axis([0.5 timeline(end)+0.5 -sep N*sep])
		
## SET the GLOBAL location ordering:
Master.Locs<-locs;
## MAKE THE INSTRUMENTAL OBSERVATION MATRIX
# inst_inds=2:1:6;
# Inst_years=ceiling(N_Recs/2):1:N_Recs; #=years for which there inst obs.
# inst_inds=2:1:8;
inst.inds<-c(seq(2,N-1,by=1));
N.Inst<-length(inst.inds);
Inst.years<-c(seq(ceiling(3*N.Recs/4),N.Recs,by=1)); #=years for which there inst obs
		
#construct the empty Inst data matrix:
Data.Matrix.Inst<-matrix(NA,N.Recs-1, N);
#fill it
Inst.noise<-mvrnorm(length(Inst.years), rep(0,N.Inst), (tau2.I)*diag(N.Inst));
Data.Matrix.Inst[Inst.years-1,inst.inds]<-Temperature.Matrix[Inst.years,inst.inds]+Inst.noise;
		
## MAKE THE PROXY OBSERVATION MATRIX
prox.inds<-c(seq(4,N-3,by=1));
Prox.years<-c(seq(2,ceiling(7*N.Recs/8),by=2));
N.Prox=length(prox.inds);
		
#construct the empty Prox data matrix:
Data.Matrix.Prox.1=matrix(NA,N.Recs-1,N);
#fill it
Prox.noise<-c(mvrnorm(length(Prox.years), rep(0,N.Prox),tau2.P*diag(N.Prox)));
Data.Matrix.Prox.1[Prox.years-1,prox.inds]<-Beta.1*Temperature.Matrix[Prox.years,prox.inds]+Prox.noise+Beta.0;
		
## MAKE THE SECOND PROXY OBSERVATION MATRIX
prox.inds<-c(seq(1,N,by=3));
Prox.years<-c(seq(2,ceiling(7*N.Recs/8),by=1));
N.Prox=length(prox.inds);
		
#construct the empty Prox data matrix:
Data.Matrix.Prox.2=matrix(NA,N.Recs-1,N);
#fill it
Prox.noise<-c(mvrnorm(length(Prox.years), rep(0,N.Prox),tau2.P.2*diag(N.Prox)));
Data.Matrix.Prox.2[Prox.years-1,prox.inds]<-Beta.1.2*Temperature.Matrix[Prox.years,prox.inds]+Prox.noise+Beta.0.2;
		
# prox_inds=4:1:8;
# Prox_years=2:1:ceiling(3*N_Recs/4);
#prox_inds=3:1:9;
#		prox_inds=4:1:N;
#		Prox_years=2:1:ceiling(2*N_Recs/4);
#		N_Prox=length(prox_inds);
#		
#		#construct the empty Prox data matrix:
#		Data_Matrix_Prox_2=NaN(N, N_Recs-1);
#		#fill it
#		Prox_noise=sqrt(tau2_P_2)*randn(N_Prox, length(Prox_years));
#		Data_Matrix_Prox_2(prox_inds, Prox_years-1)=Beta_1_2*Temperature_Matrix(prox_inds, Prox_years)+Prox_noise+Beta_0_2;
#		
#		#corrupt one time series:
#		svi=[];
#		if length(svi)==1;
#		Data_Matrix_Prox_2(prox_inds(svi), Prox_years-1)=Data_Matrix_Prox_2(prox_inds(svi), Prox_years-1)+5;#*randn(1,length(Prox_years));
#		end
		
		## PLOT THESE
#		figure(20), gcf
#		
#		for kk=1:1:N
#		plot(timeline(2:1:end),  Data_Matrix_Inst(kk, :)+(kk-1)*sep, 'ro-', 'LineWidth', 2, 'MarkerSize', 4), hold on
#		end
#		
#		for kk=1:1:N
#		plot(timeline(2:1:end),  Data_Matrix_Prox_1(kk, :)+(kk-1)*sep, 'bo-', 'LineWidth', 2, 'MarkerSize', 4), hold on
#		end
		
#		for kk=1:1:N
#		plot(timeline(2:1:end),  Data_Matrix_Prox_2(kk, :)+(kk-1)*sep, 'bo-', 'LineWidth', 2, 'MarkerSize', 4, 'color', [0.85, 0, 0.85]), hold on
#		end
#		title('Black: Truth. Red: Instrumental. Blue: Proxy. Purple: Proxy2')
#		
#		if length(svi)==1;
#		plot(timeline(2:1:end),  Data_Matrix_Prox_2(prox_inds(svi), :)+(prox_inds(svi)-1)*sep, 'bo-', 'LineWidth', 4, 'MarkerSize', 4, 'color', [0.5, 0, 0.85]), hold on
#		end
		
## CONSTRUCT data structure for BARCAST. 
		
#THIS is now very, very simple. ALL that is needed is:
#the common location vector.
#the DATA REFERECED timeline vector (i.e. BARCAST will add one entry
#to the beginning)
#area weights for calculating the block average
#indices of the locations in the central portion for calculating the
#central block average.
#Inst data matrix.
#Prox data matrix.
#rm(BARCAST.INPUT)
BARCAST.INPUT<-list(Master.Locs,
		timeline[-1],
		matrix(1,length(Master.Locs[,1]),1),
		seq(1,length(Master.Locs[,1])),
		Data.Matrix.Inst,
		Data.Matrix.Prox.1,
		Data.Matrix.Prox.2)
names(BARCAST.INPUT)<-c("Master.Locs",
		"Data.timeline",
		"Areas",
		"Inds.Central",
		"Inst.Data",
		"Prox.Data.1",
		"Prox.Data.2")

## save the input structure and the truth

dir.create("../TestData", showWarnings = FALSE)
save(BARCAST.INPUT, file="../TestData/BARCASTINPUTvNewMeth1.R", ascii = TRUE)
save(Temperature.Matrix, file="../TestData/TrueTempsv1.R", ascii = TRUE)
save(Pars.TRUE, file="../TestData/ParsTrue.R", ascii = TRUE)
