# This calculates the area weighted average of a spatio-temporal time series. It
# first defines a proportionality constant for each grid point. It assumes that
# the grid is evenly spaced in lat-lon coordinates. So, it simply takes the
# cosine of the latitude as the factor. To this end, it first reads the
# coordinates that should be stored in a file, each line one lon / lat pair.
# The corresponding data is in the respective rows of another file.
#
# FORMAT DEFINITIONS
# locations, ASCII file
# longitude1 \t latitude1
# longitude2 \t latitude2
# longitude3 \t latitude3
# ... \t ...
#
# data, ASCII file
# y1loc1 \t y1loc2 \t y1loc3 \t ...
# y2loc1 \t y2loc2 \t y2loc3 \t ...
# y3loc1 \t y3loc2 \t y3loc3 \t ...
# ...
#
# The area average is calculated by
# AreaWeight <- cosine(Coordinates[,2]) / mean(cosine(Coordinates[,2]))
# AverageData <- AreaWeight %*% Data
#
AreaWeightedAverage <- function( LocationFileName, DataFileName){
  
  LocMatrix <- as.matrix( read.table( LocationFileName) );
  DatMatrix <- as.matrix( read.table( DataFileName) );

  AreaWeight <- cos(pi/180*LocMatrix[,2]) / sum(cos(pi/180*LocMatrix[,2]) );

  AvgData <- DatMatrix %*% AreaWeight

  return( AvgData)
}

