## load the data
load(BARCAST.infile);

Prior.Pars(BARCAST.datdir, BARCAST.infile);
Initial.vals(BARCAST.datdir, BARCAST.infile, Pars.Selector = 1);

#break it apart
Locs <- BARCAST.INPUT$Master.Locs;
N.Locs <- length(Locs[,1]); #Number of locations:

timeline<-c(BARCAST.INPUT$Data.timeline[1]-1, BARCAST.INPUT$Data.timeline);
N.Times <- length(timeline)-1; #Number of DATA times

#get the number of proxy types:
N.PT<-length(grep("Prox.Data", names(BARCAST.INPUT)));

#stack the three data matrices, one next to the other
#the first N_Locs COLS are the Inst, the next N_Locs COLS the first proxy
#type, the next the third. . . . .. Each ROW a year. The first
#corresponds to the SECOND entry in timeline. 
Data.ALL <- BARCAST.INPUT$Inst.Data;
for (kk in seq(1,N.PT) ){
	iname<-paste("Prox.Data.",toString(kk),sep="");
	ipos=seq(1:length(BARCAST.INPUT))[names(BARCAST.INPUT)==iname];
	Data.ALL <- cbind(Data.ALL , BARCAST.INPUT[[ipos]])
}

#Priors and MH jumping parameters, from Prior_pars_vNewModel
load(paste ( BARCAST.datdir, "/PRIORSvNewMeth1.R", sep="") );
load(paste ( BARCAST.datdir, "/MHparsvNewMeth1.R", sep="") );

#Initial values from Initial_par_vals_vNewModel
load(paste ( BARCAST.datdir, "/INITIALVALSvNewMeth1.R", sep="") );

  #The Order of THE SCALAR parameters WILL ALWAYS thus:
  #1 = alpha, the AR(1) coefficient
  #2 = mu, the constant par in the linear mean of the AR(1) process
  #3 = sigma2, the partial sill in the spatial covariance matrix
  #4 = phi, the range parameter in the spatial covariance matrix
  #5 = tau2_I, the Inst measurement error
  #6 = tau2_P, the measurement error, first PROX type
  #7 = invTemp, the inverse temperature of the specific chain
  # these are followed by the parameters for the proxies
  # type
  # noise level
  # beta_0
  # beta_1
  # type dependent variable (beta_2, or the ADM, or a spacial or temporal scale)

  ## CALCULATE FIXED QUANTITIES (DO NOT DEPEND ON UNKOWN PARAMETERS)

  #The matrix of distances between every possible pair of points, (I,P,R)
  All.DistMat=EarthDistances(Locs);

  #The H(t) selection matrix. 
  #Basically, H(t) tells us which Inst and prox
  #locations have measurements for a given year. So: define H(t) for each
  #year as an indicator vector, and thus HH a matrix such that each column is
  #the indicator vector for that year. In other words, this is the complete
  #indicator matrix for the presence of data::
  #1=YES Measurement;
  #0=NO  Measurement
  #Simply a ZERO wherever there is a NaN in Data_ALL, and a ONE whereever
  #this is a value
  HH.SelectMat=matrix(1,dim(Data.ALL)[1],dim(Data.ALL)[2])-is.na(Data.ALL);

  #The total number of Inst/Prox Observations are needed for several
  #conditional posteriors, and can be calculated from the HH_SelectMat:
  M.InstProx <- matrix(NA,1+N.PT,1);
  #vectot: first the total number of inst obsm then the total number of each
  #		prox type, in order.
  #Inst:
  M.InstProx[1]=sum(HH.SelectMat[,1:N.Locs]);
  #Prox:
  for ( kk in seq(1,N.PT) ){
	  M.InstProx[kk+1]=sum(HH.SelectMat[,seq(kk*N.Locs+1,(kk+1)*N.Locs)]);
  }

  ## Set the initial values of the Field matrix and Current Parameter Vector
  # These will be updated and then saved at each iteration of the sampler.
  # They are initially filled with the values from INITIAL_VALS.
  # Parameter/field values at each step of the gibbs sampler are taken from
  # these objects, and new draws override the current entries. This ensures
  # that each step of the Gibbs sampler is ALWAYS using the most recent set of ALL 
  # parameters, without having to deal with +/-1 indices.
		
  #Array of the estimated true temperature values, set to the initial values:  
  Temperature.MCMC.Sampler <- INITIAL.VALS$Temperature;
  #Order: All I, P with locs common to I, Rest of the P, R.
  #In other words, ordered the same as InstProx_locs, then with Rand_locs
  #added on
  #note that
  #[Inst_locs; Prox_locs] = InstProx_locs([Inst_inds,Prox_inds],:)
  #SO: Temperature_MCMC_Sampler([Inst_inds,Prox_inds], KK) extracts the
  #elements that can be compared to the corresponding time of DATA_Mat
		
  # Current values of the scalar parameters
  # remove field names
  
  INITIAL.SCALAR.VALS <- type.convert(paste(INITIAL.VALS[1:7]));
  CURRENT.PARS <- INITIAL.SCALAR.VALS;
  names( CURRENT.PARS) <- names(INITIAL.VALS[1:7])

  INITIAL.VALS <- INITIAL.VALS[-c(1:7,length(INITIAL.VALS))]
  print(INITIAL.VALS)
  ProxNameVec <- names(unlist(INITIAL.VALS) )
  CProx <- matrix(-999, ncol=length(grep("type",ProxNameVec)), nrow=5)
  for ( Pnum in seq(1, N.PT) ){
    CProx[seq(1, (length(INITIAL.VALS[[Pnum]]))) ,Pnum] <- unlist(INITIAL.VALS[[Pnum]])
  }
  CProx <- t(CProx)
  # Now name the entries
#  for ( Pnum in seq(1, N.PT) ){
#    names( CProx[ Pnum,]) <- paste(c("type","beta.0","beta.1","beta.2"),Pnum, sep=".")
#  }

  ## DEFINE EMPTY MATRICES that will be filled with the sampler

  #DEFINE the empty parameter matrix:
  N.Pars <- length(CURRENT.PARS);

  # I remove the logging of all runs, only the data of the last run
  # will be saved in a logfile in the data directory

  Parameters.MCMC.Samples <- matrix(NA, (N.Pars + length(unlist(CProx)) ), Sampler.Its);
  rownames( Parameters.MCMC.Samples) <- c(names(CURRENT.PARS), names(unlist(INITIAL.VALS) ) )

  ## CALCULATE PARAMETER DEPENDENT QUANTITIES
  #that are used several times in the sampler
  #
  #The idea: calculate the quantities with the initial parameter values, then
  #update as soon as possible, leaving the variablle name the same

  ## To speed up the code 
  #1. Find the UNIQUE missing data patterns, number them.
  #2. Index each year by the missing data pattern.
  #3. For each missing data pattern, calculate the inverse and square root of
  #the conditional posterior covariance of a T_k, and stack them
  #4. Rewrite the T_k_Updater to simply call these matrices. 
  #This reduces the number of matrix inversions for each FULL iteration of
  #the sampler to the number of UNIQUE data patterns, and reduces the number
  #for the pre iterations to 2. 

  library(mgcv);
  U.Patterns <- uniquecombs(HH.SelectMat);
  Pattern.by.Year <- attr(U.Patterns, "index");

  #calculate the initial spatial correlation matrix, and its inverse
  #these are needed several times.
  #AS SOON as phi is updated, this is updated, ensuring that the
  #correlation matrix and its inverse are always up to date, regardless of
  #the order of the sampling below.

  CURRENT.spatial.corr.mat <- exp(-CURRENT.PARS[4]*All.DistMat);
  CURRENT.inv.spatial.corr.mat <- solve(CURRENT.spatial.corr.mat, method="chol");

  # Input the CURRENT_PARS vector and etc into Covariance_Patterns, which returns the
  # covariance matrix for each missing data pattern
  Cov.List <- Covariance.Patterns(U.Patterns, CURRENT.PARS, CProx, CURRENT.inv.spatial.corr.mat, N.Locs, N.PT);
  CURRENT.COV.ARRAY <- Cov.List$Matrix
  UPPER.CURRENT.COV.ARRAY <- Cov.List$Upper

