source("Proxy_Time_Updater.R", local=TRUE)

rank.mpi <- mpi.comm.rank()
size <- mpi.comm.size()
swaps.attempted <- 0
swaps.accepted <- 0

GatherTheta <- function( theta ){
  rank.mpi <- mpi.comm.rank()
  size <- mpi.comm.size()

  if( rank.mpi == 1 ){
    for ( rank.partner.mpi in seq(2, size - 1) ){
      mpi.send.Robj( theta[ 1], dest=rank.partner.mpi, tag=rank.mpi)
      theta[ rank.partner.mpi] <- mpi.recv.Robj( rank.partner.mpi, rank.partner.mpi)
    }
    for ( rank.partner.mpi in seq(2, size - 1) ){
      mpi.send.Robj( theta, dest=rank.partner.mpi, tag=rank.mpi)
    }
  } else {
    theta[ 1] <- mpi.recv.Robj( 1, 1)
    mpi.send.Robj( theta[ rank.mpi], dest=1, tag= rank.mpi)
    theta <- mpi.recv.Robj( 1, 1)
  }
  # print( theta)
  return(theta)
}

invTemp <- rep(0, size - 1)
for(r in 1:size-1){
  temp=(r-1)/(size-2);
  invTemp[ r] <- invTemp.min^temp;
}

RankList <- sort(invTemp, index.return=TRUE, decreasing=TRUE)$ix
CURRENT.PARS[7] <- invTemp[ rank.mpi]
rank     <- RankList[ rank.mpi]


## RUN THE SAMPLER
for ( samples in seq(1, pre.Sampler.Its) ){
  for ( tsamples in seq(1, thin)) {
    NPat <- length(CURRENT.COV.ARRAY[1,1,])
    # print("t updater")
    out <- .Fortran("TUpdater", PRIORS$T.0, CURRENT.PARS,
                    CURRENT.COV.ARRAY,UPPER.CURRENT.COV.ARRAY)
    
    out <- .Fortran("GetTMatrix", t(Temperature.MCMC.Sampler))
    Temperature.MCMC.Sampler <- t(out[[1]])
	
    ## SAMPLE AR(1) coefficient    
    out <- .Fortran("Alpha_Updater", PRIORS$alpha, CURRENT.PARS)
    CURRENT.PARS[1] <- out[[2]][1]
    # print("alpha done")
    
    ## SAMPLE AR(1) mean constant parameter, mu:
    out <- .Fortran("Mu_Updater", PRIORS$mu, CURRENT.PARS)
    CURRENT.PARS[2] <- max(min(out[[2]][2],10),-10);
    # print("mu done")
    
    ## SAMPLE Partial Sill of the spatial covaraince martrix
    out <- .Fortran("Sigma2_Updater", PRIORS$sigma2, CURRENT.PARS)
    #ARTIFICIALLY put a cieling at, say, 5.
    #CHECK a posterior that, one the algorithm has converged, ALL draws are
    #lower than this. 
    CURRENT.PARS[3]=min(5, out[[2]][3]);
    # print("sigma 2 done")
    
    ## SAMPLE Range Parameter of the spatial covaraince martrix (METROPOLIS)
    # This also updates the spatial corelation matrix and its inverse
    out <- .Fortran("Phi_Updater", PRIORS$phi, CURRENT.PARS, CURRENT.inv.spatial.corr.mat,
           All.DistMat, MHpars$log.phi)
    CURRENT.PARS[4] <- out[[2]][4]
    CURRENT.PARS[5] <- out[[2]][5]
    CURRENT.inv.spatial.corr.mat <- out[[3]]
    # print("phi done")

    ## SAMPLE Instrumental measurement error
    out <- .Fortran("Tau2I_Updater", PRIORS$tau2.I, CURRENT.PARS, M.InstProx[1]);
    #ARTIFICIALLY put a cieling at, say, 5.
    #CHECK a posterior that, one the algorithm has converged, ALL draws are
    #lower than this. 
    CURRENT.PARS[6]=min(1, out[[2]][6]);
    # print("tau2I done")
    
    ## NEED TO LOOP THE SAMPLING OF THE PROXY PARAMETERS
    ##
    ## For each proxy type this needs to be done differently.
    for ( Pnum in seq(1, N.PT) ){
      out <- .Fortran( "getCProx", CProx)
      CProx <- out[[1]]
      # Check for proxy type
      if( CProx[ Pnum , 1] == 20){
        # This includes updating tau2P
        CProx[ Pnum ,] <- ADM_Updater( Pnum, ADMs[[Pnum]],inverseTemp = CURRENT.PARS[7])
        pIdx <- which( colSums( Data.external[,(Pnum*N.Locs+1):((Pnum+1)*N.Locs)] != -99) > 0)[1]
        ProxyADM <- make_timeval( ADMs[[Pnum]]$adm[,CProx[ Pnum ,5]],
          ADMs[[Pnum]]$data, BARCAST.INPUT$Data.timeline)
        Data.external[, Pnum*N.Locs+pIdx] <- ProxyADM
        ProxyADM[ ProxyADM == -99 ] <- NA
        Data.ALL[, Pnum*N.Locs+pIdx] <- ProxyADM
        HH.SelectMat <- matrix(1,dim(Data.ALL)[1],dim(Data.ALL)[2])-is.na(Data.ALL)
        U.Patterns <- mgcv::uniquecombs(HH.SelectMat)
        Pattern.by.Year <- attr(U.Patterns, "index")
        NPat <- dim(U.Patterns)[1]
        .Fortran( "updateUPat", t(U.Patterns), as.integer(Pattern.by.Year), as.integer(NPat))
      } else {
        ## SAMPLE Proxy measurement error
        out <- .Fortran("Tau2P_Updater", unlist(PRIORS[[6+Pnum]][2]), 
          as.integer(Pnum), M.InstProx[Pnum+1]);
      }
    
      ## SAMPLE Additive constant in the proxy observation equation
      out <- .Fortran("Beta0_Updater", unlist(PRIORS[[6+Pnum]][3]), as.integer(Pnum), M.InstProx[Pnum+1]);
      
      ## SAMPLE Scaling constant in the proxy observation equation
      out <- .Fortran("Beta1_Updater", unlist(PRIORS[[6+Pnum]][4]), as.integer(Pnum))

      if( CProx[ Pnum , 1] == 1){
        out <- .Fortran("Beta2_Updater", unlist(PRIORS[[6+Pnum]][5]), as.integer(Pnum))
      }
      
    }
    # print("proxies done")
    
	  out <- .Fortran( "getCProx", CProx)
    CProx <- out[[1]]
    ## UPDATE the covariance arrays used in the T_k_Updater step
    Cov.List <- Covariance.Patterns(U.Patterns,
        CURRENT.PARS,
        CProx,
        CURRENT.inv.spatial.corr.mat,
        N.Locs, N.PT);
    CURRENT.COV.ARRAY <- Cov.List$Matrix 
    UPPER.CURRENT.COV.ARRAY <- Cov.List$Upper
    # print("cov array done")
    .Fortran("set_ciscm", CURRENT.inv.spatial.corr.mat)
    # print("iscm updated")
  }
  # Append the Cprox proxy parameters to the model parameters
  # print("CProx")
  Parameters.MCMC.Samples[, samples] <- c(CURRENT.PARS, unlist(t(CProx)));
  
  save(list="Temperature.MCMC.Sampler",file=paste(BARCAST.datdir,"/step_",samples,".R",sep=""));
  save(list = "Parameters.MCMC.Samples", file = paste(BARCAST.datdir,"/Pars.R",sep=""));
  print(paste("Finished pre switching iteration", samples, "of", pre.Sampler.Its));
  print(CURRENT.PARS, digits=3);
  print(CProx, digits=3)
}

