# This loads sample data from BARCASTINPUTvNewMeth1.R that has been created with the
# ConstructTestDatavNM.R tool and will then create a set of ADMs for the input data.
load("TrueTempsv1.R")
load("BARCASTINPUTvNewMeth1.R")

NYears <- dim(Temperature.Matrix)[1]
NLocs  <- dim(Temperature.Matrix)[2]

numholes <- 4
lenholes <- 2*floor(NYears/100)

admlist <- list()

# first create data with holes and put some noise onto it.
data <- Temperature.Matrix[,20]
noise <- rnorm( length(data), 0, 1)
data <- data + noise
for( tHole in seq(numholes)){
  data[ floor(NYears/(numholes +1)*(tHole)) + 1:lenholes] <- NA
}

NAIdx <- which( is.na(data))

admlist$data <- data[ which(!is.na(data))]
# Careful: When creating the time line, respect that the data we constructed
# from (the target True Temperatures) begin in year 0 instead of year 1 because
# BARCAST is also guessing that one and we need to check it!
admlist$adm  <- cbind( c(0,BARCAST.INPUT$Data.timeline)[ which(!is.na(data))] ,
   seq( to=max(BARCAST.INPUT$Data.timeline), by=1, length.out=sum(!is.na(data)) ) )
admlist$admIdx <- 1
admlist$CProx <- NA
for( admIdx in seq(20)){
  admlist$adm  <- cbind( admlist$adm, sort( sort(c(0,BARCAST.INPUT$Data.timeline)[-sample( NAIdx, length(NAIdx)-1 )], decreasing=TRUE)[1:sum(!is.na(data))] ))
}
for( admIdx in seq(20)){
  admlist$adm  <- cbind( admlist$adm, sort( sample(c(0,BARCAST.INPUT$Data.timeline), sum(!is.na(data)) ) ) )
}
# Check the ranges
apply( admlist$adm,2,range,na.rm=TRUE)

ADMs <- list()
ADMs[[1]] <- NA

ADMs[[2]] <- admlist
BARCAST.INPUT$Prox.Data.2[,20] <- data[-1]

save(list=c("BARCAST.INPUT","ADMs"),file="BARCASTINPUTvNewMeth1_proxtime.R")

