# Author: Joe Werner
# Version: 0.1
# Date: 23.09.
#
# This program reads the temperature arrays from the huge number of
# files that is created by each simulation run. The file name is 
# assumed to be constant with a suffix "_(stepnumber).R"
#
#
Gather.Temp.Data <- function( path, basename="step", startIt=2500, stopIt=5000,thinIt=10){
  setwd( path);
  FileList <- paste(basename, "_", seq(startIt, stopIt, thinIt), ".R", sep="");
  NFile <- length(FileList);
  load(FileList[1]);
  Nyear <- dim(Temperature.MCMC.Sampler)[1]
  Nlocs <- dim(Temperature.MCMC.Sampler)[2]
  
  TempDist <- array(NA, c(Nyear, Nlocs, NFile), dimnames=c("year", "loc", "filenumber"));
  TempDist[,,1] <- Temperature.MCMC.Sampler;
  for (FIdx in seq(2, NFile)){
    load(FileList[FIdx]);
    TempDist[,,FIdx] <- Temperature.MCMC.Sampler;
  }
  
  TempMean <- matrix(NA, Nyear, Nlocs);
  TempSdev <- matrix(NA, Nyear, Nlocs);
  TempQuant <- array(NA, c(Nyear, Nlocs,7));
  for (LIdx in seq(1, Nlocs)){
    TempMean[, LIdx] <- rowMeans(TempDist[, LIdx, ], na.rm=TRUE);
    TempSdev[, LIdx] <- (rowMeans(TempDist[, LIdx,]^2,na.rm=TRUE)-(TempMean[, LIdx])^2)^.5;
    for (YIdx in seq(1, Nyear)){
      TempQuant[YIdx, LIdx,] <- quantile(TempDist[YIdx, LIdx, ], probs=c(.05,.1,.25,.5,.75,.9,.95), na.rm=TRUE);
    }
  }
  TempData <- list(Mean=TempMean, SDev=TempSdev, Quantiles=TempQuant);
  returnlist <- list(TempDist, TempData);
  return(returnlist);
}

Gather.Temp.Mean <- function( path, basename="step", startIt=2500, stopIt=5000,thinIt=10){
  setwd( path);
#  FileList <- dir(pattern=paste(basename,"[1-5][0-9][0-9][0-9].R",sep="_"));
  FileList <- paste(basename, "_", seq(startIt, stopIt, thinIt), ".R", sep="");
  NFile <- length(FileList);
  load(FileList[1]);
  Nyear <- dim(Temperature.MCMC.Sampler)[1]
  Nlocs <- dim(Temperature.MCMC.Sampler)[2]

  TempMean <- matrix(0, Nyear, Nlocs);
  TempSdev <- matrix(0, Nyear, Nlocs);
  
  for (FIdx in seq(1, NFile)){
    load(FileList[FIdx]);
    TempMean <- Temperature.MCMC.Sampler + TempMean;
    TempSdev <- Temperature.MCMC.Sampler^2 + TempSdev;
  }
  
  TempData <- list(Mean=TempMean/NFile, SDev=TempSdev^.5/NFile);
  return(TempData);
}

