
# Author: Martin Tingley, Joe Werner (R adaption)
###############################################################################

require("mgcv")

Covariance.Patterns <- function( U.Pat, C.pars, C.Prox, C.iscm, N.L, N.PT){
  #FINDS the conditonal posterior covariance, and its square root, for each
  #unique pattern of missing data. Used to update T_k. 
  #
  # outputs are: posterior covariance and its square root for each missing
  # data pattern

  #number of patterns
  N.Pat <- length(U.Pat[,1]);
  #define the empty arrays to be filled
  New.post.cov.ARRAY <- array(NA, dim=c(N.L, N.L, N.Pat) );
  New.post.cov.UPPER <- array(NA, dim=c(N.L, N.L, N.Pat) );
  err.Icov.Vec <- matrix( C.pars[6]^(-1), N.L, 1);
  space.IcovM <- C.iscm*C.pars[3]^(-1);
  for ( PT in seq(1, N.PT) ){
          err.Icov.Vec <- rbind( err.Icov.Vec, matrix( C.Prox[ PT, 2]^(-1), N.L, 1) );
  }
  err.IcovM <- diag(c( err.Icov.Vec));

  for ( JJ in seq (1, N.Pat) ){
          H.Mat <- diag(U.Pat[JJ, 1:N.L]);
          for ( PT in seq(1, N.PT) ){
                  H.Mat <- rbind( H.Mat, C.Prox[ PT, 4]*diag(U.Pat[JJ, seq(PT*N.L +1, (PT+1)*N.L)] ) );
          }
          icovmat <- space.IcovM*(1+C.pars[1]^2) + t(H.Mat) %*% err.IcovM %*% H.Mat;
          post.covMat <- solve( icovmat);
          New.post.cov.ARRAY[,,JJ] <- post.covMat;
          New.post.cov.UPPER[,,JJ] <- t(chol(post.covMat));
  }

  returnlist <- list()
  returnlist$Matrix <- New.post.cov.ARRAY
  returnlist$Upper <- New.post.cov.UPPER
  return(returnlist);
}

